import numpy as np

# load precomputed energies
energies = np.load('slab_energies.npy')
h2_energy = np.load('h2_energy.npy')

# compute binding energies per H adsorbate
Nmax = len(energies)-1
binding_energies = np.zeros(Nmax)
for N in range(1, Nmax+1):
    binding_energies[N-1] = (energies[N] - energies[0] - float(N)/2*h2_energy)/N

#print absolut energies
print("Absolut energies: slabs [eV]")
print(energies)
print("Absolut energy: H2")
print(h2_energy)

#print binding energies
print("Binding energies [eV]")
print(binding_energies)
np.save('binding_energies.npy', binding_energies)
